<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Zetechup Academy — Admission Form</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <style>
        :root {
            /* Light professional theme with blue accents */
            --page-bg: #f8fafc;
            /* slate-50 */
            --card-bg: #ffffff;
            /* white */
            --text: #0f172a;
            /* slate-900 */
            --muted: #475569;
            /* slate-600 */
            --border: #e2e8f0;
            /* slate-200 */
            --ring: #93c5fd;
            /* blue-300 */
            --primary: #2563eb;
            /* blue-600 */
            --primary-2: #0ea5e9;
            /* sky-500 for subtle gradients */
            --danger: #dc2626;
            /* red-600 */
            --success: #166534;
            /* green-800 */
            --shadow: 0 10px 30px rgba(2, 8, 23, .06);
        }

        * {
            box-sizing: border-box
        }

        html,
        body {
            height: 100%
        }

        body {
            margin: 0;
            font-family: ui-sans-serif, system-ui, Segoe UI, Roboto, Inter, Arial;
            background:
                radial-gradient(1200px 400px at 80% -100px, rgba(14, 165, 233, .10), transparent 70%),
                radial-gradient(1000px 300px at -5% -120px, rgba(37, 99, 235, .10), transparent 70%),
                var(--page-bg);
            color: var(--text);
        }

        .container {
            max-width: 1000px;
            margin: 48px auto;
            padding: 0 16px
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 16px;
            color: var(--primary);
            letter-spacing: .2px;
            font-weight: 800;
            text-transform: uppercase;
            font-size: 14px
        }

        .brand .logo {
            width: 36px;
            height: 36px;
            border-radius: 10px;
            background: linear-gradient(135deg, var(--primary), var(--primary-2));
            display: grid;
            place-items: center;
            color: white;
            font-weight: 900;
            box-shadow: var(--shadow);
        }

        .header {
            display: flex;
            align-items: flex-end;
            justify-content: space-between;
            gap: 16px;
            margin-bottom: 18px
        }

        h1 {
            margin: 0;
            font-size: 28px
        }

        .sub {
            margin: 4px 0 0;
            color: var(--muted)
        }

        .card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 24px;
            box-shadow: var(--shadow)
        }

        form {
            display: grid;
            grid-template-columns: repeat(12, 1fr);
            gap: 16px
        }

        .field {
            grid-column: span 12
        }

        .col-6 {
            grid-column: span 12
        }

        @media (min-width:720px) {
            .col-6 {
                grid-column: span 6
            }
        }

        label {
            display: block;
            font-size: 13px;
            color: var(--muted);
            margin: 0 0 6px
        }

        .req::after {
            content: " *";
            color: var(--primary)
        }

        input,
        select,
        textarea {
            width: 100%;
            padding: 12px 14px;
            border-radius: 10px;
            border: 1px solid var(--border);
            background: #ffffff;
            color: var(--text);
            outline: none;
            transition: .15s;
        }

        input:focus,
        select:focus,
        textarea:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(37, 99, 235, .12)
        }

        .hint {
            font-size: 12px;
            color: var(--muted);
            margin-top: 6px
        }

        .error {
            color: var(--danger);
            font-size: 12px;
            display: none
        }

        .uploader {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 10px;
            border: 1px dashed #cbd5e1;
            border-radius: 10px;
            background: #fafafa
        }

        .preview {
            width: 44px;
            height: 44px;
            border-radius: 8px;
            background: #eff6ff;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 11px;
            color: var(--muted);
            overflow: hidden;
            border: 1px solid var(--border)
        }

        .preview img {
            width: 100%;
            height: 100%;
            object-fit: cover
        }

        .actions {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
            margin-top: 8px
        }

        .btn {
            padding: 12px 16px;
            border-radius: 10px;
            border: 1px solid transparent;
            cursor: pointer;
            font-weight: 700
        }

        .btn.primary {
            background: linear-gradient(135deg, var(--primary), #3b82f6);
            color: #fff
        }

        .btn.secondary {
            background: #ffffff;
            color: var(--text);
            border-color: var(--border)
        }

        .btn:focus {
            outline: none;
            box-shadow: 0 0 0 4px rgba(37, 99, 235, .18)
        }

        .footer-hint {
            margin-top: 10px;
            color: var(--muted);
            font-size: 12px
        }

        .note {
            background: #eff6ff;
            border: 1px solid #bfdbfe;
            color: #1e3a8a;
            padding: 10px 12px;
            border-radius: 10px;
            font-size: 13px
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="brand">
            <div class="logo">Z</div>
            Zetechup Academy
        </div>

        <div class="header">
            <div>
                <h1>Admission Form</h1>
                <p class="sub">Fill the details below. Admin will review and assign batch & class timing.</p>
            </div>
            <div class="note">Blue light theme • Professional UI • Mobile friendly</div>
        </div>

        <div class="card">
            <form id="admissionForm" action="submit_admission.php" method="POST" enctype="multipart/form-data" novalidate>
                <!-- Personal -->
                <div class="field col-6">
                    <label class="req">Full Name</label>
                    <input type="text" name="full_name" placeholder="e.g., Muhammad Ali" required />
                    <div class="error">Full Name is required.</div>
                </div>
                <div class="field col-6">
                    <label class="req">Father’s Name</label>
                    <input type="text" name="father_name" placeholder="e.g., Ahmed Ali" required />
                    <div class="error">Father’s Name is required.</div>
                </div>

                <div class="field col-6">
                    <label class="req">Father’s Number</label>
                    <input type="tel" name="father_number" placeholder="03XX-XXXXXXX" pattern="0[0-9]{3}-?[0-9]{7}" required />
                    <div class="hint">Format: 03XX-XXXXXXX</div>
                    <div class="error">Please enter a valid father’s number.</div>
                </div>

                <div class="field col-6">
                    <label class="req">CNIC / B-Form</label>
                    <input type="text" name="cnic" placeholder="12345-1234567-1" pattern="[0-9]{5}-[0-9]{7}-[0-9]" required />
                    <div class="hint">Format: 12345-1234567-1</div>
                    <div class="error">Please match CNIC/B-Form format.</div>
                </div>
                <div class="field col-6">
                    <label for="gender">Gender</label>
                    <select name="gender" id="gender" required>
                        <option value="">— Select —</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                        <option value="Other">Other</option>
                    </select>

                </div>
                <div class="field col-6">
                    <label class="req">Date of Birth</label>
                    <input type="date" name="dob" required />
                    <div class="error">Date of Birth is required.</div>
                </div>

                <div class="field col-6">
                    <label class="req">Contact Number</label>
                    <input type="tel" name="contact_number" placeholder="03XX-XXXXXXX" pattern="0[0-9]{3}-?[0-9]{7}" required />
                    <div class="hint">Format: 03XX-XXXXXXX</div>
                    <div class="error">Please enter a valid contact number.</div>
                </div>

                <div class="field col-6">
                    <label class="req">Email Address</label>
                    <input type="email" name="email" placeholder="you@example.com" required />
                    <div class="error">Valid email is required.</div>
                </div>

                <div class="field col-6">
                    <label class="req">Address</label>
                    <input type="text" name="address" placeholder="House, Street, Area, City" required />
                    <div class="error">Address is required.</div>
                </div>

                <!-- Course -->
                <div class="field col-6">
                    <label class="req">Select Course</label>
                    <select name="course" required>
                        <option value="">— Choose a course —</option>
                        <option>Web Development</option>
                        <option>Graphic Designing</option>
                        <option>MS Office</option>
                        <option>Digital Marketing</option>
                        <option>Freelancing</option>
                        <option>Amazon VA</option>
                    </select>
                    <div class="error">Please select a course.</div>
                </div>

                <div class="field col-6">
                    <label class="req">Preferred Timing</label>
                    <select name="preferred_timing" required>
                        <option value="">— Select timing —</option>
                        <option>Morning</option>
                        <option>Evening</option>
                        <option>Weekend</option>
                    </select>
                    <div class="error">Please choose a timing.</div>
                </div>

                <div class="field col-6">
                    <label class="req">Preferred Start Date</label>
                    <input type="date" name="preferred_start_date" required />
                    <div class="error">Please choose a start date.</div>
                </div>

                <!-- Upload -->
                <div class="field col-6">
                    <label>Upload CNIC/B-Form Copy (PNG/JPG/PDF, max 2MB)</label>
                    <div class="uploader">
                        <div class="preview" id="filePreview">CNIC</div>
                        <input type="file" name="cnic_file" id="cnic_file" accept=".png,.jpg,.jpeg,.pdf" />
                    </div>
                    <div class="hint">Optional — helps faster verification.</div>
                </div>

                <!-- Actions -->
                <div class="field actions">
                    <button class="btn secondary" type="reset">Reset</button>
                    <button class="btn primary" type="submit">Submit Application</button>
                </div>

                <div class="footer-hint">By submitting, you agree that the admin may assign any available batch & class timing.</div>
            </form>
        </div>
    </div>

    <script>
        // Simple client-side validation + preview
        const form = document.getElementById('admissionForm');
        form.addEventListener('submit', (e) => {
            let valid = true;
            form.querySelectorAll('input[required], select[required]').forEach(el => {
                const err = el.parentElement.querySelector('.error');
                if (!el.checkValidity()) {
                    valid = false;
                    if (err) err.style.display = 'block';
                    if (valid === false && el.scrollIntoView) {
                        el.scrollIntoView({
                            behavior: 'smooth',
                            block: 'center'
                        });
                    }
                } else if (err) {
                    err.style.display = 'none';
                }
            });
            if (!valid) e.preventDefault();
        });

        form.querySelectorAll('input, select').forEach(el => {
            el.addEventListener('input', () => {
                const err = el.parentElement.querySelector('.error');
                if (err) {
                    err.style.display = el.checkValidity() ? 'none' : 'block';
                }
            });
        });

        // File preview (image only)
        const fileInput = document.getElementById('cnic_file');
        const preview = document.getElementById('filePreview');
        fileInput?.addEventListener('change', () => {
            const f = fileInput.files?.[0];
            if (!f) {
                preview.innerText = 'CNIC';
                return;
            }
            if (f.type.startsWith('image/')) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.innerHTML = '<img alt="preview" />';
                    preview.querySelector('img').src = e.target.result;
                };
                reader.readAsDataURL(f);
            } else {
                preview.textContent = (f.name || 'File');
            }
        });
    </script>
</body>

</html>