<?php
// /admin/_bootstrap.php
session_start();

// Adjust this path only if your db.php lives elsewhere:
require_once __DIR__ . '/../db.php';  // expects C:\xampp\htdocs\zetechup\db.php

// Sanity checks
if (!function_exists('mysqli_connect')) {
  die("PHP mysqli extension is NOT enabled. Edit php.ini -> enable extension=mysqli and restart Apache.");
}
if (!isset($conn) || !($conn instanceof mysqli)) {
  die("db.php did not create a valid MySQLi \$conn. Check path and contents of /zetechup/db.php.");
}

// Small helpers
function is_logged_in(): bool { return !empty($_SESSION['admin_id']); }
function require_login(){ if(!is_logged_in()){ header('Location: login.php'); exit; } }
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
