<?php
// /admin/_layout.php — Top-bar layout with dropdowns + helpers

if (!function_exists('h')) {
  function h($s)
  {
    return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8');
  }
}

function admin_header($title = 'Admin')
{
  $self = basename($_SERVER['PHP_SELF'] ?? '');

  // Top-level & dropdown structure (update labels/paths here if needed)
 $menu = [
    ['type' => 'item', 'href' => 'index.php', 'icon' => 'fa-home', 'label' => 'Dashboard'],

    // -------- Admissions --------
    [
      'type' => 'dropdown', 'icon' => 'fa-user-check', 'label' => 'Admissions',
      'children' => [
        ['href' => 'requests_pending.php',         'icon' => 'fa-hourglass-half', 'label' => 'Pending Requests'],
        ['href' => 'request_view.php',             'icon' => 'fa-eye',            'label' => 'View Request'],
        ['href' => 'admin_admission_create.php',   'icon' => 'fa-user-plus',      'label' => 'Create Admission'],
        ['href' => 'registrations.php',            'icon' => 'fa-list-check',     'label' => 'Registrations'],
        ['href' => 'students.php',                 'icon' => 'fa-users',          'label' => 'Students'],
        ['href' => 'admin_student_manage.php',     'icon' => 'fa-user-gear',      'label' => 'Manage Students'],
        ['href' => 'student_accounts.php',         'icon' => 'fa-id-card',        'label' => 'Student Accounts'],
        ['href' => 'portal_control.php',           'icon' => 'fa-lock',           'label' => 'Portal Control'],
      ]
    ],

    // -------- Academics --------
    [
      'type' => 'dropdown', 'icon' => 'fa-graduation-cap', 'label' => 'Academics',
      'children' => [
        ['href' => 'course_create.php',  'icon' => 'fa-plus', 'label' => 'Create Course'],
        ['href' => 'courses_list.php',   'icon' => 'fa-book', 'label' => 'Courses List'],
        ['href' => 'time_slots.php',     'icon' => 'fa-clock', 'label' => 'Time Slots'],
        ['href' => 'batch_create.php',   'icon' => 'fa-layer-group', 'label' => 'Create Batch'],
        ['href' => 'batches_list.php',   'icon' => 'fa-table', 'label' => 'All Batches'],
        ['href' => 'attendance.php',     'icon' => 'fa-calendar-check', 'label' => 'Attendance'],
        ['href' => 'daily_work.php',     'icon' => 'fa-clipboard', 'label' => 'Daily Work'],
        ['href' => 'class_content.php',  'icon' => 'fa-video', 'label' => 'Daily Class Uploads'],
        ['href' => 'chat_admin.php',     'icon' => 'fa-comments', 'label' => 'Chat Admin'],
      ]
    ],

    // -------- Finance --------
    [
      'type' => 'dropdown', 'icon' => 'fa-sack-dollar', 'label' => 'Finance',
      'children' => [
        ['href' => 'fees.php',   'icon' => 'fa-credit-card', 'label' => 'Fee'],
        ['href' => 'fee_control.php',   'icon' => 'fa-credit-card', 'label' => 'Fee Control'],
        ['href' => 'fees_overview.php', 'icon' => 'fa-chart-pie',   'label' => 'Fees Overview'],
        ['href' => 'fees_report.php',   'icon' => 'fa-chart-line',  'label' => 'Fees Report'],
      ]
    ],

    // -------- Support --------
    [
      'type' => 'dropdown', 'icon' => 'fa-headset', 'label' => 'Support',
      'children' => [
        ['href' => 'support_tickets.php', 'icon' => 'fa-ticket', 'label' => 'Support Tickets'],
      ]
    ],

    ['type' => 'item', 'href' => 'logout.php', 'icon' => 'fa-right-from-bracket', 'label' => 'Logout'],
  ];
?>
  <!DOCTYPE html>
  <html lang="en">

  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= h($title) ?> · Zetechup Admin</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
      :root {
        --wrap: 1280px;
        --border: #e9ecef;
        --bg: #f8f9fa;
        --blue: #4361ee;
        --text: #495057;
        --shadow: 0 2px 10px rgba(0, 0, 0, .08);
        --radius: 8px;
      }

      * {
        margin: 0;
        padding: 0;
        box-sizing: border-box
      }

      body {
        font-family: system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, "Helvetica Neue", Arial;
        background: var(--bg);
        color: #1f2937;
        padding: 20px
      }

      a {
        text-decoration: none;
        color: inherit
      }

      /* MENU BAR */
      .menu-bar {
        background: #fff;
        padding: 0 40px;
        box-shadow: var(--shadow);
        border-bottom: 1px solid var(--border);
        border-radius: var(--radius)
      }

      .menu {
        display: flex;
        align-items: center;
        list-style: none
      }

      .menu li {
        position: relative
      }

      .menu a {
        color: var(--text);
        font-weight: 600;
        padding: 18px 20px;
        display: flex;
        align-items: center;
        gap: 10px;
        transition: .2s;
        border-bottom: 3px solid transparent
      }

      .menu a:hover {
        color: var(--blue);
        background: #f8f9fe;
        border-bottom-color: var(--blue)
      }

      .menu a.active {
        color: var(--blue);
        background: #f0f4ff;
        border-bottom-color: var(--blue)
      }

      .menu a i {
        font-size: 16px;
        width: 20px;
        text-align: center
      }

      /* DROPDOWN */
      .dropdown-menu {
        position: absolute;
        top: 100%;
        left: 0;
        background: #fff;
        min-width: 240px;
        border-radius: 0 0 var(--radius) var(--radius);
        box-shadow: var(--shadow);
        border: 1px solid var(--border);
        border-top: none;
        opacity: 0;
        visibility: hidden;
        transform: translateY(-8px);
        transition: .2s;
        z-index: 1000
      }

      .dropdown:hover .dropdown-menu {
        opacity: 1;
        visibility: visible;
        transform: none
      }

      .dropdown-menu li {
        width: 100%
      }

      .dropdown-menu a {
        padding: 12px 16px;
        border-bottom: 1px solid #f1f3f4;
        border-left: 3px solid transparent;
        font-weight: 500
      }

      .dropdown-menu a:hover {
        background: #f8f9fe;
        border-left-color: var(--blue)
      }

      .dropdown>a::after {
        content: '\f078';
        font-family: 'Font Awesome 6 Free';
        font-weight: 900;
        font-size: 12px;
        margin-left: 6px;
        transition: .2s
      }

      .dropdown:hover>a::after {
        transform: rotate(180deg)
      }

      /* MOBILE */
      .mobile-menu-btn {
        display: none;
        background: none;
        border: none;
        font-size: 24px;
        color: #495057;
        cursor: pointer;
        padding: 12px 10px
      }

      @media (max-width: 900px) {
        body {
          padding: 12px
        }

        .menu-bar {
          padding: 0 16px
        }

        .mobile-menu-btn {
          display: block
        }

        .menu {
          display: none;
          flex-direction: column;
          position: absolute;
          top: 100%;
          left: 0;
          right: 0;
          background: #fff;
          border-radius: 0 0 var(--radius) var(--radius);
          box-shadow: var(--shadow);
          z-index: 1000
        }

        .menu.active {
          display: flex
        }

        .menu li {
          width: 100%
        }

        .menu a {
          padding: 14px 16px;
          border-bottom: 1px solid #f1f3f4;
          border-left: 4px solid transparent
        }

        .menu a.active {
          border-left-color: var(--blue)
        }

        .dropdown-menu {
          position: static;
          opacity: 1;
          visibility: visible;
          transform: none;
          box-shadow: none;
          border: 0;
          background: #f8f9fa;
          display: none
        }

        .dropdown.active .dropdown-menu {
          display: block
        }

        .dropdown>a::after {
          content: '\f078';
          margin-left: auto
        }

        .dropdown.active>a::after {
          transform: rotate(180deg)
        }
      }

      /* CONTENT WRAP & CARDS */
      .wrap {
        max-width: var(--wrap);
        margin: 16px auto 0
      }

      .card {
        background: #fff;
        border: 1px solid var(--border);
        border-radius: 10px;
        padding: 14px;
        box-shadow: var(--shadow)
      }

      .grid {
        display: grid;
        grid-template-columns: repeat(12, 1fr);
        gap: 10px
      }

      .col-12 {
        grid-column: span 12
      }

      .col-8 {
        grid-column: span 8
      }

      .col-6 {
        grid-column: span 6
      }

      .col-4 {
        grid-column: span 4
      }

      .col-3 {
        grid-column: span 3
      }

      @media (max-width: 900px) {
        .grid {
          gap: 8px
        }

        .col-8,
        .col-6,
        .col-4,
        .col-3 {
          grid-column: span 12
        }
      }

      label {
        display: block;
        font-size: 12px;
        color: #64748b;
        margin-bottom: 4px
      }

      input,
      select,
      textarea {
        width: 100%;
        background: #fff;
        border: 1px solid var(--border);
        border-radius: 10px;
        padding: 8px 10px;
        height: 38px
      }

      textarea {
        min-height: 90px
      }

      .btn {
        background: #fff;
        border: 1px solid var(--border);
        color: #111827;
        border-radius: 10px;
        padding: 8px 12px;
        cursor: pointer
      }

      .btn.primary {
        background: var(--blue);
        color: #fff;
        border-color: var(--blue)
      }

      .btn.primary:hover {
        filter: brightness(.98)
      }

      .badge {
        padding: 2px 8px;
        border-radius: 999px;
        font-size: 12px;
        font-weight: 700;
        border: 1px solid #e5e7eb;
        display: inline-block
      }

      .badge.warn {
        background: #fff7ed;
        color: #9a3412
      }

      .badge.danger {
        background: #fee2e2;
        color: #991b1b
      }

      .table-wrap {
        overflow: auto;
        border-radius: 10px;
        border: 1px solid #e5e7eb
      }

      table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0
      }

      thead th {
        position: sticky;
        top: 0;
        background: #f1f5f9;
        font-weight: 700;
        z-index: 1
      }

      th,
      td {
        padding: 10px 12px;
        border-bottom: 1px solid #e5e7eb;
        vertical-align: middle
      }

      tbody tr:hover {
        background: #f8fafc
      }
    </style>
  </head>

  <body>

    <nav class="menu-bar" role="navigation" aria-label="Main">
      <button class="mobile-menu-btn" id="mobileMenuBtn"><i class="fas fa-bars"></i></button>
      <ul class="menu" id="mainMenu">
        <?php foreach ($menu as $m): ?>
          <?php if ($m['type'] === 'item'):
            $active = ($self === $m['href']) ? 'active' : ''; ?>
            <li>
              <a href="<?= h($m['href']) ?>" class="<?= $active ?>">
                <i class="fas <?= h($m['icon']) ?>"></i><span><?= h($m['label']) ?></span>
              </a>
            </li>
          <?php elseif ($m['type'] === 'dropdown'): ?>
            <?php
            // mark dropdown active if any child matches
            $isOpen = false;
            foreach ($m['children'] as $ch) {
              if ($self === $ch['href']) {
                $isOpen = true;
                break;
              }
            }
            $parentActive = $isOpen ? 'active' : '';
            ?>
            <li class="dropdown<?= $isOpen ? ' active' : '' ?>">
              <a href="#" class="<?= $parentActive ?>">
                <i class="fas <?= h($m['icon']) ?>"></i><span><?= h($m['label']) ?></span>
              </a>
              <ul class="dropdown-menu">
                <?php foreach ($m['children'] as $ch):
                  $childActive = ($self === $ch['href']) ? 'active' : ''; ?>
                  <li>
                    <a href="<?= h($ch['href']) ?>" class="<?= $childActive ?>">
                      <i class="fas <?= h($ch['icon']) ?>"></i> <?= h($ch['label']) ?>
                    </a>
                  </li>
                <?php endforeach; ?>
              </ul>
            </li>
          <?php endif; ?>
        <?php endforeach; ?>
      </ul>
    </nav>

    <main class="wrap">
    <?php
  }

  function admin_footer()
  {
    ?>
    </main>

    <script>
      // Mobile menu toggle
      const mobileBtn = document.getElementById('mobileMenuBtn');
      const mainMenu = document.getElementById('mainMenu');
      if (mobileBtn && mainMenu) {
        mobileBtn.addEventListener('click', () => mainMenu.classList.toggle('active'));
        document.addEventListener('click', (e) => {
          if (window.innerWidth > 900) return;
          if (!mainMenu.contains(e.target) && !mobileBtn.contains(e.target)) {
            mainMenu.classList.remove('active');
            document.querySelectorAll('.dropdown').forEach(d => d.classList.remove('active'));
          }
        });
      }

      // Mobile dropdown tap
      document.querySelectorAll('.dropdown > a').forEach(link => {
        link.addEventListener('click', e => {
          if (window.innerWidth <= 900) {
            e.preventDefault();
            const dd = link.parentElement;
            document.querySelectorAll('.dropdown').forEach(d => {
              if (d !== dd) d.classList.remove('active');
            });
            dd.classList.toggle('active');
          }
        });
      });

      // Desktop: close dropdown active class on resize up
      window.addEventListener('resize', () => {
        if (window.innerWidth > 900) {
          document.querySelectorAll('.dropdown').forEach(d => d.classList.remove('active'));
          mainMenu.classList.remove('active');
        }
      });

      // Set active by current page (safety if HTML caching)
      document.addEventListener('DOMContentLoaded', () => {
        const current = location.pathname.split('/').pop() || 'index.php';
        const links = document.querySelectorAll('.menu a[href]');
        links.forEach(a => {
          if (a.getAttribute('href') === current) {
            links.forEach(x => x.classList.remove('active'));
            a.classList.add('active');
            const menu = a.closest('.dropdown-menu');
            if (menu) menu.previousElementSibling.classList.add('active');
          }
        });
      });
    </script>
  </body>

  </html>
<?php
  }
