<?php
// /admin/course_create.php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';

// Handle Create
$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '')==='add') {
  $name        = trim($_POST['name'] ?? '');
  $dur         = (int)($_POST['duration_months'] ?? 3);
  $fee_type_in = $_POST['fee_type'] ?? 'PER_COURSE';
  $fee_type    = ($fee_type_in === 'PER_MONTH') ? 'PER_MONTH' : 'PER_COURSE';
  $course_fee  = (int)($_POST['course_fee'] ?? 0);
  $monthly_fee = (int)($_POST['monthly_fee'] ?? 0);

  if ($name==='') {
    $err = "Course name is required.";
  } else {
    $st = mysqli_prepare($conn, "INSERT INTO courses(name,duration_months,course_fee,fee_type,monthly_fee,is_active) VALUES (?,?,?,?,?,1)");
    if(!$st){ die("Prepare failed: " . mysqli_error($conn)); }
    mysqli_stmt_bind_param($st, "siisi", $name, $dur, $course_fee, $fee_type, $monthly_fee);
    if(!mysqli_stmt_execute($st)){ die("Execute failed: " . mysqli_stmt_error($st)); }
    mysqli_stmt_close($st);
    header("Location: courses_list.php?msg=" . urlencode("Course added"));
    exit;
  }
}

admin_header('Create Course');
?>
<h2 style="display:flex;align-items:center;gap:10px;margin:0 0 8px">
  Create Course
  <a class="btn" href="courses_list.php">View All Courses</a>
</h2>

<?php if($err): ?>
  <div class="card mt-3" style="background:#fff1f2;border:1px solid #fecaca;color:#991b1b"><?= h($err) ?></div>
<?php endif; ?>

<div class="card col-12" style="position:relative;overflow:hidden">
  <div style="position:absolute;right:-24px;top:-24px;width:120px;height:120px;background:linear-gradient(135deg,#bfdbfe,#93c5fd);opacity:.25;border-radius:50%"></div>
  <h3 style="margin:0 0 12px;color:#2563eb">New Course</h3>

  <form method="post" style="display:grid;gap:10px">
    <input type="hidden" name="action" value="add">

    <label>Name</label>
    <input name="name" placeholder="e.g. Web Development" required>

    <div class="grid" style="grid-template-columns:repeat(12,1fr);gap:10px">
      <div style="grid-column:span 6">
        <label>Duration (months)</label>
        <input type="number" name="duration_months" value="3" min="1" step="1">
      </div>
      <div style="grid-column:span 6">
        <label>Fee Type</label>
        <select name="fee_type" id="feeTypeAdd">
          <option value="PER_COURSE">Per Course (one-time)</option>
          <option value="PER_MONTH">Per Month</option>
        </select>
      </div>
    </div>

    <div class="grid" style="grid-template-columns:repeat(12,1fr);gap:10px">
      <div style="grid-column:span 6">
        <label>Course Fee (one-time)</label>
        <input type="number" name="course_fee" value="0" min="0" step="100" id="courseFeeAdd">
      </div>
      <div style="grid-column:span 6">
        <label>Monthly Fee (if per-month)</label>
        <input type="number" name="monthly_fee" value="0" min="0" step="100" id="monthlyFeeAdd">
      </div>
    </div>

    <div style="display:flex;justify-content:flex-end">
      <button class="btn primary" style="width:max-content">Create Course</button>
    </div>
    <div style="font-size:12px;color:#475569">Tip: Fee type ke mutabiq relevant amount field active rahegi.</div>
  </form>
</div>

<script>
const feeTypeAdd    = document.getElementById('feeTypeAdd');
const courseFeeAdd  = document.getElementById('courseFeeAdd');
const monthlyFeeAdd = document.getElementById('monthlyFeeAdd');
function syncAddFees(){
  if (feeTypeAdd.value === 'PER_MONTH') {
    monthlyFeeAdd.disabled = false;
    courseFeeAdd.disabled = true;
  } else {
    monthlyFeeAdd.disabled = true;
    courseFeeAdd.disabled = false;
  }
}
feeTypeAdd.addEventListener('change', syncAddFees);
syncAddFees();
</script>

<?php admin_footer(); ?>
