<?php
require_once __DIR__ . '/_bootstrap.php';
if (is_logged_in()) { header('Location: index.php'); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $email = trim($_POST['email'] ?? '');
  $pass  = $_POST['password'] ?? '';

  // NOTE: For simplicity, plain text. Prefer password_hash in production.
  $stmt = mysqli_prepare($conn, "SELECT id, name FROM admins WHERE email=? AND password=? LIMIT 1");
  mysqli_stmt_bind_param($stmt, "ss", $email, $pass);
  mysqli_stmt_execute($stmt);
  $res = mysqli_stmt_get_result($stmt);
  if ($row = mysqli_fetch_assoc($res)) {
    $_SESSION['admin_id'] = $row['id'];
    $_SESSION['admin_name'] = $row['name'];
    header('Location: index.php'); exit;
  } else {
    $error = 'Invalid email or password';
  }
  mysqli_stmt_close($stmt);
}
?>
<!doctype html><html><head><meta charset="utf-8"><title>Admin Login</title>
<style>
body{font-family:Arial;background:#f8fafc;display:grid;place-items:center;min-height:100vh;margin:0}
.card{background:#fff;border:1px solid #e2e8f0;border-radius:12px;padding:20px;width:min(380px,92%)}
input{width:100%;padding:10px;border:1px solid #e2e8f0;border-radius:10px;margin:6px 0}
button{width:100%;padding:10px;border:0;border-radius:10px;background:#2563eb;color:#fff;font-weight:700}
.err{color:#b91c1c;margin:8px 0}
</style></head><body>
<div class="card">
  <h2>Admin Login</h2>
  <?php if($error): ?><div class="err"><?=h($error)?></div><?php endif; ?>
  <form method="post">
    <label>Email</label><input type="email" name="email" required>
    <label>Password</label><input type="password" name="password" required>
    <button type="submit">Login</button>
  </form>
</div>
</body></html>
