<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';

$id = (int)($_GET['id'] ?? 0);
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $reason = trim($_POST['reason'] ?? '');
  $st = mysqli_prepare($conn, "UPDATE admission_requests SET status='REJECTED', rejection_reason=?, updated_at=NOW() WHERE id=? AND status='PENDING'");
  mysqli_stmt_bind_param($st, "si", $reason, $id);
  mysqli_stmt_execute($st);
  mysqli_stmt_close($st);
  header('Location: requests_pending.php'); exit;
}

admin_header('Reject Request');
?>
<h2>Reject Admission Request</h2>
<div class="card mt-3">
  <form method="post">
    <label>Reason (optional)</label>
    <textarea name="reason" rows="4" placeholder="Reason..." style="width:100%;padding:10px;border:1px solid #e2e8f0;border-radius:10px"></textarea>
    <div class="mt-3">
      <button class="btn primary" type="submit">Reject</button>
      <a class="btn" href="requests_pending.php">Cancel</a>
    </div>
  </form>
</div>
<?php admin_footer(); ?>
