<?php
// /admin/requests_pending.php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/_layout.php';

// -------- Filters (GET) --------
$q        = trim($_GET['q'] ?? '');
$course   = trim($_GET['course'] ?? '');
$date_from= trim($_GET['from'] ?? '');
$date_to  = trim($_GET['to'] ?? '');

// Build WHERE safely
$where = " WHERE status='PENDING' ";
if ($q !== '') {
  $esc = mysqli_real_escape_string($conn, $q);
  $where .= " AND (full_name LIKE '%$esc%' OR cnic LIKE '%$esc%' OR requested_course LIKE '%$esc%') ";
}
if ($course !== '') {
  $escC = mysqli_real_escape_string($conn, $course);
  $where .= " AND requested_course = '$escC' ";
}
if ($date_from !== '') {
  $escF = mysqli_real_escape_string($conn, $date_from);
  $where .= " AND DATE(created_at) >= '$escF' ";
}
if ($date_to !== '') {
  $escT = mysqli_real_escape_string($conn, $date_to);
  $where .= " AND DATE(created_at) <= '$escT' ";
}

// Load distinct courses for filter
$coursesRes = mysqli_query($conn, "SELECT DISTINCT requested_course FROM admission_requests WHERE status='PENDING' AND requested_course<>'' ORDER BY requested_course");

// Main rows (include gender + cnic_file_path)
$sql = "
  SELECT id, full_name, gender, cnic, requested_course, preferred_timing,
         preferred_start_date, cnic_file_path, created_at
  FROM admission_requests
  $where
  ORDER BY created_at DESC
  LIMIT 500
";
$rows = mysqli_query($conn, $sql);

// total count
$cnt = (int)mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) c FROM admission_requests WHERE status='PENDING'"))['c'];

admin_header('Pending Requests');
?>
<style>
.badge{padding:2px 8px;border-radius:999px;font-size:12px;font-weight:700;border:1px solid transparent;display:inline-block}
.badge.blue{background:#dbeafe;color:#1e40af;border-color:#bfdbfe}
.badge.ok{background:#dcfce7;color:#166534;border-color:#86efac}
.badge.warn{background:#fff7ed;color:#9a3412;border-color:#fed7aa}
.badge.neutral{background:#f1f5f9;color:#334155;border-color:#e5e7eb}
.table-wrap{overflow:auto;border-radius:10px;border:1px solid var(--border)}
thead th{position:sticky;top:0;background:#f1f5f9;z-index:1}
tbody tr:hover{background:#f8fafc}
.actions .btn{padding:6px 10px}
</style>

<h2 style="display:flex;align-items:center;gap:10px;margin:0 0 8px">
  Pending Admission Requests
  <span class="badge blue">Total: <?= number_format($cnt) ?></span>
</h2>

<div class="card">
  <form method="get" style="display:flex;gap:8px;flex-wrap:wrap;align-items:end">
    <div>
      <label>Search</label>
      <input name="q" value="<?=h($q)?>" placeholder="Name / CNIC / Course" style="max-width:220px">
    </div>
    <div>
      <label>Course</label>
      <select name="course" style="min-width:180px">
        <option value="">All</option>
        <?php while($c = mysqli_fetch_assoc($coursesRes)): ?>
          <option value="<?=h($c['requested_course'])?>" <?=$course===$c['requested_course']?'selected':''?>>
            <?=h($c['requested_course'])?>
          </option>
        <?php endwhile; ?>
      </select>
    </div>
    <div>
      <label>From</label>
      <input type="date" name="from" value="<?=h($date_from)?>">
    </div>
    <div>
      <label>To</label>
      <input type="date" name="to" value="<?=h($date_to)?>">
    </div>
    <div style="display:flex;gap:8px">
      <button class="btn">Apply</button>
      <a class="btn" href="requests_pending.php">Reset</a>
    </div>
  </form>
</div>

<div class="card mt-3">
  <div class="table-wrap">
    <table style="min-width:1100px">
      <thead>
        <tr>
          <th style="text-align:center">ID</th>
          <th style="text-align:left">Applicant</th>
          <th>Gender</th>
          <th>CNIC</th>
          <th style="text-align:left">Course</th>
          <th>Timing</th>
          <th>Preferred Start</th>
          <th>Requested</th>
          <th>CNIC File</th>
          <th style="width:180px">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php if(mysqli_num_rows($rows)===0): ?>
          <tr><td colspan="10" style="text-align:center;padding:24px;color:#64748b">No pending requests found.</td></tr>
        <?php endif; ?>

        <?php while($r = mysqli_fetch_assoc($rows)): ?>
          <?php
            $g = strtoupper(trim($r['gender'] ?? ''));
            $gBadge = ($g==='MALE') ? '<span class="badge ok">Male</span>' :
                      (($g==='FEMALE') ? '<span class="badge warn">Female</span>' :
                                         '<span class="badge neutral">'.h($r['gender'] ?: 'Other').'</span>');
          ?>
          <tr>
            <td style="text-align:center"><?= (int)$r['id'] ?></td>
            <td style="font-weight:700"><?= h($r['full_name']) ?></td>
            <td style="text-align:center"><?= $gBadge ?></td>
            <td><?= h($r['cnic']) ?></td>
            <td><?= h($r['requested_course']) ?></td>
            <td style="text-align:center"><?= h($r['preferred_timing']) ?></td>
            <td style="text-align:center"><?= h($r['preferred_start_date']) ?></td>
            <td style="text-align:center"><?= h($r['created_at']) ?></td>
            <td style="text-align:center">
              <?php if(!empty($r['cnic_file_path'])): ?>
                <a class="btn" href="../<?=h($r['cnic_file_path'])?>" target="_blank">View</a>
              <?php else: ?>
                <span class="badge neutral">—</span>
              <?php endif; ?>
            </td>
            <td class="actions" style="text-align:center;white-space:nowrap">
              <a class="btn primary" href="request_view.php?id=<?= (int)$r['id'] ?>">Review</a>
              <a class="btn" style="border-color:#fecaca;color:#b91c1c;margin-left:6px"
                 href="request_reject.php?id=<?= (int)$r['id'] ?>"
                 onclick="return confirm('Reject this request?');">Reject</a>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php admin_footer(); ?>
