<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Zetechup Academy - Coming Soon</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        body {
            background: linear-gradient(to right, #000428, #004e92);
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            font-family: 'Poppins', sans-serif;
            padding: 20px;
        }

        .top-heading {
            color: #ffe680;
            font-size: 38px;
            font-weight: 700;
            margin-bottom: 20px;
            text-shadow: 0 0 10px rgba(255,255,255,0.3);
        }

        .coming-card {
            backdrop-filter: blur(12px);
            background: rgba(255, 255, 255, 0.15);
            border-radius: 25px;
            padding: 50px;
            text-align: center;
            color: #fff;
            width: 95%;
            max-width: 650px;
            box-shadow: 0 0 30px rgba(255, 255, 255, 0.15);
        }

        .coming-card h1 {
            font-size: 45px;
            font-weight: 800;
        }

        .coming-card p {
            font-size: 18px;
            margin-top: 10px;
            opacity: 0.9;
        }

        .btn-custom {
            width: 100%;
            margin-top: 15px;
            border-radius: 30px;
            padding: 15px;
            font-size: 20px;
        }

        .social-icons i {
            font-size: 25px;
            margin: 0 12px;
            color: #fff;
            transition: 0.3s;
            cursor: pointer;
        }

        .social-icons i:hover {
            color: #ffe680;
            transform: scale(1.2);
        }

        .whatsapp-btn {
            background: #25D366;
            color: white;
            padding: 15px 40px;
            font-size: 22px;
            border-radius: 40px;
            margin-top: 25px;
            display: inline-block;
            text-decoration: none;
            box-shadow: 0 0 15px rgba(0,0,0,0.3);
            transition: 0.3s;
        }

        .whatsapp-btn:hover {
            background: #1ebe5d;
            transform: scale(1.05);
        }
    </style>
</head>
<body>

    <!-- Admission Open Heading -->
    <div class="top-heading">Admission Open</div>

    <!-- Card -->
    <div class="coming-card">
        <h1>Zetechup Academy</h1>
        <p>Our new portal is coming soon. Stay connected with us!</p>

        <!-- Buttons -->
        <a href="Admission.php" class="btn btn-warning btn-custom">Admission</a>
        <a href="user/user_login.php" class="btn btn-light btn-custom">Login</a>

        <!-- Social Icons -->
        <div class="social-icons mt-4">
            <i class="fab fa-facebook-f"></i>
            <i class="fab fa-instagram"></i>
            <i class="fab fa-youtube"></i>
        </div>
    </div>

    <!-- WhatsApp Button (Outside Card) -->
    <a href="https://wa.me/+923452377795" class="whatsapp-btn" target="_blank">
        <i class="fab fa-whatsapp"></i> WhatsApp
    </a>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
