<?php
if (!function_exists('h')) {
  function h($s)
  {
    return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8');
  }
}

function user_header($title = 'Student Portal')
{
  $self = basename($_SERVER['PHP_SELF'] ?? '');
?>
  <!DOCTYPE html>
  <html lang="en">

  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?= h($title) ?> · Zetechup Academy</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
      :root {
        --blue: #2563eb;
        --border: #e5e7eb;
        --bg: #f8fafc;
        --text: #0f172a;
        --muted: #64748b;
        --wrap: 980px;
      }

      * {
        box-sizing: border-box;
        margin: 0;
        padding: 0
      }

      body {
        margin: 0;
        background: var(--bg);
        font: 14px/1.45 system-ui, -apple-system, Segoe UI, Roboto;
        color: var(--text)
      }

      a {
        text-decoration: none !important;
        color: var(--blue)
      }

      .topbar {
        background: #fff;
        border-bottom: 1px solid var(--border);
        box-shadow: 0 1px 4px rgba(0, 0, 0, .05)
      }

      .brand-area {
        max-width: var(--wrap);
        margin: auto;
        text-align: center;
        padding: 10px 0;
        font-weight: 800;
        color: var(--blue);
        font-size: 20px
      }

      nav {
        max-width: var(--wrap);
        margin: auto;
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        gap: 10px;
        justify-content: center;
        padding: 10px;
        border-top: 1px solid var(--border);
        border-bottom: 1px solid var(--border);
        background: #fff
      }

      nav a {
        color: #0f172a;
        padding: 8px 10px;
        border-radius: 8px;
        font-weight: 500
      }

      nav a.active {
        background: #dbeafe;
        border: 1px solid #bfdbfe;
        color: #1e40af
      }

      .userbox {
        position: fixed;
        right: 20px;
        top: 10px;
        display: flex;
        align-items: center;
        gap: 10px;
        z-index: 50
      }

      .notif {
        position: relative;
        font-size: 18px;
        cursor: pointer;
        color: #475569
      }

      .notif-badge {
        position: absolute;
        top: -2px;
        right: -4px;
        background: #ef4444;
        color: #fff;
        border-radius: 50%;
        width: 10px;
        height: 10px;
        font-size: 0
      }

      .profile {
        position: relative
      }

      .avatar {
        width: 34px;
        height: 34px;
        border-radius: 50%;
        background: #dbeafe;
        color: #1e3a8a;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        cursor: pointer
      }

      .menu {
        position: absolute;
        right: 0;
        top: 42px;
        background: #fff;
        border: 1px solid var(--border);
        border-radius: 10px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, .1);
        display: none;
        min-width: 160px
      }

      .menu a {
        display: block;
        padding: 10px 12px;
        color: #0f172a
      }

      .menu a:hover {
        background: #f1f5f9
      }

      .card {
        background: #fff;
        border: 1px solid var(--border);
        border-radius: 12px;
        padding: 14px
      }

      .wrap {
        max-width: var(--wrap);
        margin: 20px auto;
        padding: 0 14px
      }

      @media(max-width:700px) {
        nav {
          flex-direction: column;
          gap: 4px
        }
      }
      /* Prevent underline or border-bottom on any nav links */
nav a, nav a:hover, nav a:focus, nav a:active {
  text-decoration: none !important;
  border-bottom: none !important;
  outline: none;
}

    </style>
  </head>

  <body>
    <header class="topbar">
      <div class="brand-area"><i class="fa-solid fa-graduation-cap"></i> Zetechup Academy — Student Portal</div>

      <nav>
        <a href="index.php" class="<?= $self === 'index.php' ? 'active' : '' ?>"><i class="fa-solid fa-house"></i> Dashboard</a>
        <a href="daily_classes.php"><i class="fa-solid fa-book-open"></i> Classes</a>
        <a href="daily_work.php"><i class="fa-solid fa-pen"></i> Work</a>
        <!-- <a href="attendance.php"><i class="fa-solid fa-calendar-check"></i> Attendance</a> -->
        <!-- <a href="fees_overview.php"><i class="fa-solid fa-wallet"></i> Fees</a> -->
        <a href="support.php"><i class="fa-solid fa-headset"></i> Support</a>
        <!-- <a href="chat.php"><i class="fa-solid fa-comments"></i> Chat</a> -->
      </nav>

      <div class="userbox">
        <div id="notif" class="notif" title="Notifications"><i class="fa-regular fa-bell"></i><span id="nb" class="notif-badge"></span></div>
        <div class="profile" id="profile">
          <div class="avatar" id="avatar"><?= strtoupper(substr($_SESSION['student_name'] ?? 'S', 0, 1)) ?></div>
          <div class="menu" id="pMenu">
            <a href="user_profile.php">👤 My Profile</a>
            <a href="user_change_password.php">🔐 Change Password</a>
            <a href="user_logout.php">🚪 Logout</a>
          </div>
        </div>
      </div>
    </header>
    <main class="wrap">
    <?php
  }

  function user_footer()
  { ?>
    </main>
    <script>
      // Profile dropdown
      const avatar = document.getElementById('avatar'),
        menu = document.getElementById('pMenu');
      avatar.addEventListener('click', e => {
        e.stopPropagation();
        menu.style.display = menu.style.display === 'block' ? 'none' : 'block';
      });
      document.addEventListener('click', e => {
        if (!avatar.contains(e.target)) menu.style.display = 'none';
      });

      // Notifications
      const bell = document.getElementById('notif'),
        badge = document.getElementById('nb');
      let panel = null;
      bell.addEventListener('click', async () => {
        if (panel) {
          panel.remove();
          panel = null;
          return;
        }
        panel = document.createElement('div');
        panel.style = "position:absolute;right:0;top:40px;width:250px;background:#fff;border:1px solid #e5e7eb;border-radius:10px;box-shadow:0 8px 20px rgba(0,0,0,.1);padding:8px;z-index:100";
        panel.innerHTML = "<div style='font-weight:600;margin-bottom:4px'>Notifications</div><div class='muted'>Loading...</div>";
        bell.appendChild(panel);
        const r = await fetch('support.php?action=recent_notif', {
          headers: {
            'X-Requested-With': 'XMLHttpRequest'
          }
        });
        const d = await r.json();
        let html = '';
        if (d.ok && d.items.length) {
          d.items.forEach(n => {
            html += `<div style='padding:6px 0;border-bottom:1px solid #f1f5f9;font-size:13px'>
      <b>${n.title}</b><br><span style='color:#64748b;font-size:12px'>${n.time}</span></div>`;
          });
        } else html = '<div style="color:#64748b;font-size:13px">No notifications</div>';
        panel.innerHTML = "<div style='font-weight:600;margin-bottom:4px'>Notifications</div>" + html;
      });
      document.addEventListener('click', e => {
        if (panel && !bell.contains(e.target)) {
          panel.remove();
          panel = null;
        }
      });

      // Unread badge ping
      async function checkNotif() {
        try {
          const r = await fetch('support.php?action=unread_count', {
            headers: {
              'X-Requested-With': 'XMLHttpRequest'
            }
          });
          const d = await r.json();
          if (d.ok && d.count > 0) badge.textContent = '•';
          else badge.textContent = '';
        } catch (e) {}
      }
      checkNotif();
      setInterval(checkNotif, 15000);

      // Flash hide
      setTimeout(() => {
        document.querySelectorAll('.flash').forEach(el => {
          el.style.opacity = '0';
          setTimeout(() => el.remove(), 300);
        });
      }, 3500);
    </script>
  </body>

  </html>
<?php } ?>