<?php
require_once __DIR__ . '/_user_auth.php';
require_once __DIR__ . '/_user_layout.php';
user_header('Change Password');
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<div class="container my-5" style="max-width:600px">
  <div class="card shadow-lg border-0 rounded-4">
    <div class="card-body p-4">
      <h3 class="text-primary mb-3"><i class="bi bi-shield-lock"></i> Change Password</h3>
      <p class="text-muted small mb-4">
        Keep your account secure — choose a strong password and avoid reusing your old one.
      </p>

      <form id="changeForm">
        <div class="mb-3">
          <label class="form-label fw-semibold">Current Password</label>
          <input type="password" name="old_password" class="form-control rounded-3 shadow-sm" placeholder="Enter current password" required>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">New Password</label>
          <input type="password" id="newPassword" name="new_password" class="form-control rounded-3 shadow-sm" placeholder="Enter new password" required>
          <div class="form-text">
            Must include uppercase, lowercase, number, and symbol (minimum 8 characters).
          </div>
          <div class="progress mt-2" style="height:6px;">
            <div id="strengthBar" class="progress-bar bg-danger" style="width:0%"></div>
          </div>
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold">Confirm New Password</label>
          <input type="password" id="confirmPassword" name="confirm_password" class="form-control rounded-3 shadow-sm" placeholder="Confirm new password" required>
          <div id="matchMsg" class="small mt-1"></div>
        </div>

        <div class="d-flex justify-content-end gap-2">
          <button type="reset" class="btn btn-outline-secondary">Reset</button>
          <button type="submit" class="btn btn-primary px-4">Update Password</button>
        </div>
      </form>

      <div id="resultMsg" class="mt-3 small"></div>
    </div>
  </div>

  <div class="alert alert-light mt-4 shadow-sm border rounded-3">
    <h6 class="fw-bold"><i class="bi bi-lightbulb"></i> Password Tips</h6>
    <ul class="mb-0 small text-muted">
      <li>Use at least 12 characters for extra safety.</li>
      <li>Mix uppercase (A‑Z), lowercase (a‑z), numbers (0‑9), and symbols (!@# etc.).</li>
      <li>Avoid common words (like "password123" or your name).</li>
      <li>Never reuse passwords from other accounts.</li>
    </ul>
  </div>
</div>

<script>
const newPass=document.getElementById('newPassword');
const confirmPass=document.getElementById('confirmPassword');
const matchMsg=document.getElementById('matchMsg');
const strengthBar=document.getElementById('strengthBar');

newPass.addEventListener('input',()=>{
  const val=newPass.value;let strength=0;
  if(val.length>=8)strength++;
  if(/[A-Z]/.test(val))strength++;
  if(/[a-z]/.test(val))strength++;
  if(/[0-9]/.test(val))strength++;
  if(/[^A-Za-z0-9]/.test(val))strength++;
  const pct=(strength/5)*100;
  strengthBar.style.width=pct+'%';
  strengthBar.className='progress-bar '+(pct<40?'bg-danger':pct<60?'bg-warning':pct<80?'bg-info':'bg-success');
});

confirmPass.addEventListener('input',()=>{
  matchMsg.textContent=newPass.value===confirmPass.value?'✅ Passwords match':'❌ Passwords do not match';
  matchMsg.style.color=newPass.value===confirmPass.value?'green':'red';
});

document.getElementById('changeForm').addEventListener('submit',async e=>{
  e.preventDefault();
  const fd=new FormData(e.target);
  if(newPass.value!==confirmPass.value){alert('Passwords do not match');return;}
  document.getElementById('resultMsg').textContent='Updating...';
  try{
    const res=await fetch('user_change_password_action.php',{method:'POST',body:fd});
    const data=await res.json();
    document.getElementById('resultMsg').textContent=data.ok?'✅ Password updated successfully':'❌ '+(data.error||'Update failed');
    if(data.ok){e.target.reset();strengthBar.style.width='0%';matchMsg.textContent='';}
  }catch{document.getElementById('resultMsg').textContent='Network error';}
});
</script>

<?php user_footer(); ?>
