<?php
require_once __DIR__ . '/_bootstrap.php';

// If already logged in
if (!empty($_SESSION['student_id'])) {
  header('Location: index.php');
  exit;
}

$err = $_GET['err'] ?? '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $login = trim($_POST['login'] ?? '');   // email or CNIC
  $pass  = $_POST['password'] ?? '';

  if ($login === '' || $pass === '') {
    $err = 'Enter email/CNIC and password.';
  } else {
    // Try by email first, then CNIC
    $esc = mysqli_real_escape_string($conn, $login);
    $q = mysqli_query($conn, "
      SELECT id, full_name, email, cnic, portal_password_hash, portal_enabled
      FROM students
      WHERE (email='{$esc}' OR cnic='{$esc}')
      LIMIT 1
    ");
    $u = mysqli_fetch_assoc($q);
    if (!$u) {
      $err = 'Account not found.';
    } elseif ((int)$u['portal_enabled'] !== 1) {
      $err = 'Portal access disabled. Contact academy.';
    } elseif (empty($u['portal_password_hash']) || !password_verify($pass, $u['portal_password_hash'])) {
      $err = 'Invalid password.';
    } else {
      $_SESSION['student_id']   = (int)$u['id'];
      $_SESSION['student_name'] = $u['full_name'];
      $go = !empty($_SESSION['after_login']) ? $_SESSION['after_login'] : 'index.php';
      unset($_SESSION['after_login']);
      header('Location: '.$go);
      exit;
    }
  }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Student Login · Zetechup</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
:root{--border:#e5e7eb;--blue:#2563eb}
body{margin:0;background:#f8fafc;font:14px/1.45 system-ui,-apple-system,Segoe UI}
.box{max-width:380px;margin:60px auto;background:#fff;border:1px solid var(--border);border-radius:14px;padding:18px;box-shadow:0 8px 24px rgba(15,23,42,.06)}
h2{margin:0 0 12px;color:#0f172a}
label{display:block;font-size:12px;color:#64748b;margin-bottom:4px}
input{width:100%;height:40px;border:1px solid var(--border);border-radius:10px;padding:8px 10px}
.btn{width:100%;background:var(--blue);color:#fff;border:1px solid var(--blue);border-radius:10px;padding:10px;margin-top:12px;cursor:pointer}
.err{background:#fee2e2;border:1px solid #fecaca;color:#991b1b;border-radius:10px;padding:10px;margin-bottom:10px}
.small{font-size:12px;color:#64748b}
</style>
</head>
<body>
  <div class="box">
    <h2><i class="fa-solid fa-user-graduate"></i> Student Login</h2>
    <?php if($err): ?><div class="err"><?=h($err)?></div><?php endif; ?>
    <form method="post">
      <label>Email or CNIC</label>
      <input name="login" placeholder="e.g. student@site.com or 12345-1234567-1" required>
      <label style="margin-top:8px">Password</label>
      <input name="password" type="password" placeholder="••••••••" required>
      <button class="btn">Sign In</button>
    </form>
    <div class="small" style="margin-top:10px">
      <p style="margin-top:6px">
  <a href="user_verify_reset.php">Reset without email (verify by CNIC & DOB)</a>
</p>

      Trouble logging in? Contact academy to reset password.
    </div>
  </div>
</body>
</html>
