<?php
// /user/user_set_new_password.php
require_once __DIR__ . '/_bootstrap.php';

// must have short-lived reset session
$sid   = (int)($_SESSION['reset_student_id'] ?? 0);
$until = (int)($_SESSION['reset_until'] ?? 0);
$rcsrf = $_SESSION['reset_csrf'] ?? '';

if ($sid <= 0 || $until < time()) {
  // expired or missing
  $_SESSION['reset_student_id'] = null;
  $_SESSION['reset_until'] = null;
  $_SESSION['reset_csrf'] = null;
  header('Location: user_verify_reset.php?expired=1');
  exit;
}

$err = $ok = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!hash_equals($rcsrf, $_POST['csrf'] ?? '')) {
    $err = 'Invalid request. Please try again.';
  } else {
    $new = $_POST['new'] ?? '';
    $cnf = $_POST['confirm'] ?? '';
    if ($new !== $cnf) {
      $err = 'Passwords do not match.';
    } elseif (strlen($new) < 6) {
      $err = 'Password must be at least 6 characters.';
    } else {
      $hash = password_hash($new, PASSWORD_DEFAULT);
      $st = mysqli_prepare($conn, "UPDATE students SET portal_password_hash=?, portal_enabled=1, portal_force_reset=0 WHERE id=?");
      mysqli_stmt_bind_param($st, "si", $hash, $sid);
      mysqli_stmt_execute($st);
      mysqli_stmt_close($st);

      // destroy reset session
      $_SESSION['reset_student_id'] = null;
      $_SESSION['reset_until'] = null;
      $_SESSION['reset_csrf'] = null;

      $ok = 'Password set successfully. You can login now.';
      // optional redirect after 2 sec
      header("Refresh:2; url=user_login.php?msg=" . urlencode("Password updated, please login."));
    }
  }
}

?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Set New Password · Zetechup Portal</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  body{font-family:system-ui,Segoe UI,Roboto,Arial;background:#f8fafc;margin:0}
  .wrap{max-width:520px;margin:40px auto;padding:16px}
  .card{background:#fff;border:1px solid #e5e7eb;border-radius:12px;padding:16px;box-shadow:0 1px 2px rgba(0,0,0,.04),0 6px 18px rgba(0,0,0,.06)}
  h2{margin:0 0 10px;color:#0f172a}
  label{display:block;font-size:12px;color:#475569;margin:8px 0 4px}
  input{width:100%;height:38px;border:1px solid #e5e7eb;border-radius:10px;padding:8px 10px}
  .btn{background:#2563eb;color:#fff;border:1px solid #2563eb;border-radius:10px;padding:10px 14px;cursor:pointer}
  .muted{color:#64748b;font-size:13px}
  .alert{border-radius:10px;padding:10px;margin:10px 0}
  .err{background:#fee2e2;border:1px solid #fecaca;color:#991b1b}
  .ok{background:#eff6ff;border:1px solid #bfdbfe;color:#1e40af}
</style>
</head>
<body>
<div class="wrap">
  <h2>Set a New Password</h2>
  <div class="card">
    <?php if(!empty($_GET['ok'])): ?>
      <div class="alert ok">Identity verified. Please set your new password.</div>
    <?php endif; ?>
    <?php if(!empty($err)): ?>
      <div class="alert err"><?=htmlspecialchars($err)?></div>
    <?php endif; ?>
    <?php if(!empty($ok)): ?>
      <div class="alert ok"><?=htmlspecialchars($ok)?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
      <input type="hidden" name="csrf" value="<?=htmlspecialchars($rcsrf)?>">
      <label>New Password</label>
      <input name="new" type="password" minlength="6" required>
      <label>Confirm Password</label>
      <input name="confirm" type="password" minlength="6" required>

      <div style="display:flex;gap:8px;align-items:center;margin-top:12px">
        <button class="btn">Save Password</button>
        <a href="user_login.php" class="muted">Back to Login</a>
      </div>
      <div class="muted" style="margin-top:8px">This page will expire automatically after a few minutes.</div>
    </form>
  </div>
</div>
</body>
</html>
